ORCA/M Asm65816 2.1.0

0001 08BA                       eject 
0002 08BA              *****************************************************************
0003 08BA              *
0004 08BA              * DRIVER CALL:  OPEN
0005 08BA              *
0006 08BA              * This call has no application with block device drivers and will
0007 08BA              * return with no error.
0008 08BA              *
0009 08BA              * ENTRY: via a 'JSR'
0010 08BA              *       <drvr_dev_num = Device Number of current device being accessed
0011 08BA              *      <drvr_tran_cnt = $00000000
0012 08BA              *               A Reg = Call Number
0013 08BA              *               X Reg = Undefined
0014 08BA              *               Y Reg = Undefined
0015 08BA              *             Dir Reg = GS/OS Direct Page
0016 08BA              *               B Reg = Undefined
0017 08BA              *               P Reg = N V M X D I Z C  E
0018 08BA              *                       x x 0 0 0 0 x x  0
0019 08BA              *
0020 08BA              * EXIT: via an 'RTS'
0021 08BA              *               A Reg = Error code
0022 08BA              *               X Reg = Undefined
0023 08BA
0024 08BA              *               Y Reg = Undefined
0025 08BA              *             Dir Reg = GS/OS Direct Page
0026 08BA              *               B Reg = Same as entry
0027 08BA              *               P Reg = N V M X D I Z C  E
0028 08BA              *                       x x 0 0 0 0 x 0  0   No error occured
0029 08BA              *                       x x 0 0 0 0 x 1  0   Error occured
0030 08BA              *
0031 08BA              *****************************************************************
0032 08BA                       export open
0033 08BA              open     proc 
0034 08BA                                                      ;using   driver_data
0035 08BA                       longa on
0036 08BA                       longi on
0037 08BA
0038 08BA A9 00 00              lda   #no_error
0039 08BD 18                    clc   
0040 08BE 60                    rts   
0041 08BF
0042 08BF                       endp 
0043 08BF                       eject 
0044 08BF              *****************************************************************
0045 08BF              *
0046 08BF              * DRIVER CALL:  WRITE
0047 08BF              *
0048 08BF              * This call executes a write to the device.  Block devices must
0049 08BF              * validate the initial block number and that the request count is
0050 08BF              * an integral multiple of the block size.  In addition the block
0051 08BF              * number of each successive block must be validated as it is
0052 08BF              * accessed when an multiple block I/O transaction is in place.
0053 08BF              *
0054 08BF              * ENTRY: via a 'JSR'
0055 08BF              *       <drvr_dev_num = Device Number of current device being accessed
0056 08BF              *       <drvr_buf_ptr = Pointer to I/O buffer
0057 08BF              *       <drvr_blk_num = Initial block number
0058 08BF              *       <drvr_req_cnt = Number of bytes to be transferred
0059 08BF              *      <drvr_blk_size = Size of block to be accessed
0060 08BF              *      <drvr_tran_cnt = $00000000
0061 08BF              *               A Reg = Call Number
0062 08BF              *               X Reg = Undefined
0063 08BF              *               Y Reg = Undefined
0064 08BF              *             Dir Reg = GS/OS Direct Page
0065 08BF              *               B Reg = Undefined
0066 08BF              *               P Reg = N V M X D I Z C  E
0067 08BF              *                       x x 0 0 0 0 x x  0
0068 08BF              *
0069 08BF              * EXIT: via an 'RTS'
0070 08BF              *      <drvr_tran_cnt = Number of bytes transferred
0071 08BF              *               A Reg = Error code
0072 08BF              *               X Reg = Undefined
0073 08BF              *               Y Reg = Undefined
0074 08BF              *             Dir Reg = GS/OS Direct Page
0075 08BF              *               B Reg = Same as entry
0076 08BF              *               P Reg = 0=m=x=e
0077 08BF              *                       Carry = 1 if error occured
0078 08BF              *                       Carry = 0 if no error occured
0079 08BF              *
0080 08BF              *****************************************************************
0081 08BF                       export write
0082 08BF              write    proc 
0083 08BF                                                      ;using   driver_data
0084 08BF                       longa on
0085 08BF                       longi on
0086 08BF
0087 08BF 20 67 05              jsr   check_access             ; did dispatch signal a fake DSW error?
0088 08C2 B0 6C                 bcs   write_exit               ; yes
0089 08C4
0090 08C4 A5 0A                 lda   drvr_req_cnt+2
0091 08C6 05 08                 ora   drvr_req_cnt             ;req count zero? (A = no_error)
0092 08C8 18                    clc   
0093 08C9 F0 65                 beq   write_exit
0094 08CB
0095 08CB A5 14                 lda   <drvr_blk_size           ; validate the current block size
0096 08CD C9 00 02              cmp   #$0200
0097 08D0 F0 30                 beq   chk_multi
0098 08D2 C9 0C 02              cmp   #$020C
0099 08D5 F0 05                 beq   chk_multiple
0100 08D7 A9 22 00     bad_parm lda   #drvr_bad_parm           ; invalid block size
0101 08DA 38                    sec   
0102 08DB 60                    rts   
0103 08DC
0104 08DC              *
0105 08DC              * Now call Int Math Toolset to do req_cnt DIV 524
0106 08DC              *
0107 08DC              chk_multiple  
0108 08DC A6 0A                 ldx   <drvr_req_cnt+2
0109 08DE 30 F7                 bmi   bad_parm                 ;I don't do negative request counts for 524
0110 08E0 A9 00 00              lda   #0
0111 08E3 48                    pha   
0112 08E4 48                    pha   
0113 08E5 48                    pha   
0114 08E6 48                    pha   
0115 08E7 DA                    phx   
0116 08E8 D4 08                 pei   <drvr_req_cnt
0117 08EA 48                    pha   
0118 08EB D4 14                 pei   <drvr_blk_size
0119 08ED A2 0B 0D 22           _LongDivide                    ;call int math for the remainder
0120 08F4 68                    pla                            ;discard quot
0121 08F5 68                    pla   
0122 08F6 68                    pla                            ;get remainder
0123 08F7 03 01                 ora   1,s                      ;get hi & lo word together in A
0124 08F9 FA                    plx   
0125 08FA AA                    tax                            ;is remainder zero?
0126 08FB F0 0C                 beq   do_write                 ;yes...
0127 08FD A9 2C 00     bad_count lda   #drvr_bad_count         ; invalid byte count
0128 0900 38                    sec   
0129 0901 60                    rts   
0130 0902              *
0131 0902              * Now see if the request count is an even multiple of the block size
0132 0902              * (block size of $0200 is much easier to perform a MOD operation on!)
0133 0902              *
0134 0902 A5 08        chk_multi lda   <drvr_req_cnt
0135 0904 29 FF 01              and   #$01FF
0136 0907 D0 F4                 bne   bad_count                ;insist req_cnt is divisible by 512
0137 0909
0138 0909                       eject 
0139 0909              *
0140 0909              * The following routine is executed for write calls
0141 0909              * directed toward class 2 block devices.
0142 0909              *
0143 0909              do_write  
0144 0909 18                    clc                            ; specify block search
0145 090A 22 04 FC 01           jsl   cache_find_blk           ; is the block in the cache?
0146 090E 90 0A                 bcc   wr_cache                 ; yes, xfer from buf to cache
0147 0910 A5 1A                 lda   <drvr_cache              ; add to cache?
0148 0912 F0 0E                 beq   wr_dev                   ; no
0149 0914 22 08 FC 01           jsl   cache_add_blk            ; else add block to cache
0150 0918 B0 08                 bcs   wr_dev                   ; if block was not allocated
0151 091A              wr_cache  
0152 091A 22 CD 17 02           jsl   buff_to_cache            ; yes, read block from cache to buffer
0153 091E 24 1A                 bit   <drvr_cache              ; deferred mode?
0154 0920 30 05                 bmi   wr_done                  ; yes, dont xfer to device
0155 0922              wr_dev    
0156 0922 20 31 09              jsr   do_sp_writeblk           ; write through to the device
0157 0925 B0 09                 bcs   write_exit               ; if device returned error
0158 0927              wr_done                                 ; 
0159 0927 20 58 11              jsr   next_blk_ptr             ; set next block address & test if more
0160 092A 90 DD                 bcc   do_write                 ; if more blocks to write
0161 092C 18                    clc                            ; all done with no errors
0162 092D A9 00 00              lda   #no_error
0163 0930              write_exit  
0164 0930 60                    rts   
0165 0931
0166 0931                       eject 
0167 0931              *****************************************************************
0168 0931              *
0169 0931              * The following routine executes a writeblock to the SmartPort
0170 0931              * device.
0171 0931              *
0172 0931              * ENTRY:        A Reg = Undefined
0173 0931              *               X Reg = Undefined
0174 0931              *               Y Reg = Undefined
0175 0931              *               B Reg = Same as program bank
0176 0931              *             Dir Reg = GS/OS Direct Page
0177 0931              *               P Reg = N V M X D I Z C  E
0178 0931              *                       x x 0 0 0 x x x  0
0179 0931              *
0180 0931              * EXIT:         A Reg = Undefined
0181 0931              *               X Reg = Undefined
0182 0931              *               Y Reg = Undefined
0183 0931              *               B Reg = Unchanged
0184 0931              *             Dir Reg = GS/OS Direct Page
0185 0931              *               P Reg = N V M X D I Z C  E
0186 0931              *                       x x 0 0 0 x x 0  0 if no error
0187 0931              *                       x x 0 0 0 x x 1  0 if error
0188 0931              *
0189 0931              *****************************************************************
0190 0931                       export do_sp_writeblk
0191 0931              do_sp_writeblk  
0192 0931 20 B0 11              jsr   setup_sp_call            ; setup SmartPort call parameters
0193 0934
0194 0934 A0 50 00              ldy   #dib_last_sts            ;was media offline last time?
0195 0937 B7 20                 lda   [drvr_dib_ptr],y
0196 0939 29 10 00              and   #%10000
0197 093C F0 07                 beq   @doStatus                ;offline so do Status to get blockcount
0198 093E A0 0A 00              ldy   #blk_cnt
0199 0941 B7 20                 lda   [drvr_dib_ptr],y
0200 0943 D0 05                 bne   @doWrite
0201 0945 20 6A 0B     @doStatus jsr   Fixup_blkcnt            ;go do DevStat to see if blockcount is known
0202 0948 B0 13                 bcs   @dswErr                  ;status returned disk switch so ERROR the Read
0203 094A
0204 094A A5 00        @doWrite lda   <drvr_dev_num            ; device number to read
0205 094C A6 14                 ldx   <drvr_blk_size           ;which block size to do?
0206 094E E0 0C 02              cpx   #$020C                   ;a mac write?
0207 0951 A2 4F 04              ldx   #blockwrite_list
0208 0954 90 03                 bcc   @10                      ;NO.
0209 0956 A2 6F 04              ldx   #writbyts_list           ;yes.
0210 0959 22 80 FC 01  @10      jsl   to_b0_core
0211 095D 60           @dswErr  rts   
0212 095E
0213 095E                       endp 
0214 095E                       eject 
0215 095E              *****************************************************************
0216 095E              *
0217 095E              * DRIVER CALL:  CLOSE
0218 095E              *
0219 095E              * This call has no application with block devices and will
0220 095E              * return with no error.
0221 095E              *
0222 095E              * ENTRY: via a 'JSR'
0223 095E              *       <drvr_dev_num = Device Number of current device being accessed
0224 095E              *      <drvr_tran_cnt = $00000000
0225 095E              *               A Reg = Call Number
0226 095E              *               X Reg = Undefined
0227 095E              *               Y Reg = Undefined
0228 095E              *             Dir Reg = GS/OS Direct Page
0229 095E              *               B Reg = Undefined
0230 095E              *               P Reg = N V M X D I Z C  E
0231 095E              *                       x x 0 0 0 0 x x  0
0232 095E              *
0233 095E              * EXIT: via an 'RTS'
0234 095E              *               A Reg = Error code
0235 095E              *               X Reg = Undefined
0236 095E              *               Y Reg = Undefined
0237 095E              *             Dir Reg = GS/OS Direct Page
0238 095E              *               B Reg = Same as entry
0239 095E              *               P Reg = N V M X D I Z C  E
0240 095E              *                       x x 0 0 0 0 x 0  0   No error occured
0241 095E              *                       x x 0 0 0 0 x 1  0   Error occured
0242 095E              *
0243 095E              *****************************************************************
0244 095E                       export close
0245 095E              close    proc 
0246 095E                                                      ;using   driver_data
0247 095E                       longa on
0248 095E                       longi on
0249 095E
0250 095E A9 00 00              lda   #no_error
0251 0961 18                    clc   
0252 0962 60                    rts   
0253 0963
0254 0963                       endp 
0255 0963                       eject 
0256 0963              *****************************************************************
0257 0963              *
0258 0963              * DRIVER CALL:  STATUS
0259 0963              *
0260 0963              * This routine supports all the standard device status calls.
0261 0963              * Any status call which is able to detect an OFFLINE or DISK
0262 0963              * SWITCHED condition should call the system service routine
0263 0963              * SET_DISKSW.  OFFLINE and DISKSW are conditions and not errors
0264 0963              * when detected by a status call and should only be returned as
0265 0963              * conditions in the status list.
0266 0963              *
0267 0963              * Status Code:  $0000   Return Device Status
0268 0963              *               $0001   Return Control Parameters
0269 0963              *               $0002   Return Wait/No Wait Mode
0270 0963              *               $0003   Return Format Options
0271 0963              *
0272 0963              * ENTRY: via a 'JSR'
0273 0963              *       <drvr_dev_num = Device Number of current device being accessed
0274 0963              *     <drvr_clist_ptr = Pointer to control list
0275 0963              *     <drvr_ctrl_code = Control code
0276 0963              *       <drvr_req_cnt = Number of bytes to be transferred
0277 0963              *      <drvr_tran_cnt = $00000000
0278 0963              *               A Reg = Call Number
0279 0963              *               X Reg = Undefined
0280 0963              *               Y Reg = Undefined
0281 0963              *             Dir Reg = GS/OS Direct Page
0282 0963              *               B Reg = Undefined
0283 0963              *               P Reg = N V M X D I Z C  E
0284 0963              *                       x x 0 0 0 0 x x  0
0285 0963              *
0286 0963              * EXIT: via an 'RTS'
0287 0963              *      <drvr_tran_cnt = Number of bytes transferred
0288 0963              *               A Reg = Error code
0289 0963              *               X Reg = Undefined
0290 0963              *               Y Reg = Undefined
0291 0963              *             Dir Reg = GS/OS Direct Page
0292 0963              *               B Reg = Same as entry
0293 0963              *               P Reg = N V M X D I Z C  E
0294 0963              *                       x x 0 0 0 0 x 0  0   No error occured
0295 0963              *                       x x 0 0 0 0 x 1  0   Error occured
0296 0963              *
0297 0963              *****************************************************************
0298 0963                       export status
0299 0963              status   proc 
0300 0963                                                      ;using   driver_data
0301 0963                       longa on
0302 0963                       longi on
0303 0963
0304 0963 A5 16                 lda   <drvr_stat_code          ; is this a get_format_options call?
0305 0965 C9 03 00              cmp   #drvr_get_format
0306 0968 F0 72                 beq   get_format               ; yes
0307 096A
0308 096A 20 67 05              jsr   check_access             ; did an access occur?
0309 096D 6E 56 03              ror   |pre_check               ; save it
0310 0970
0311 0970 22 84 FC 01           jsl   g_dispatch               ; pass call on to generic driver
0312 0974
0313 0974 B0 32                 bcs   not_dev_stat             ; if error, history cant be updated
0314 0976 A5 16                 lda   <drvr_stat_code          ; is this a return from device status?
0315 0978 D0 2E                 bne   not_dev_stat             ; no
0316 097A
0317 097A
0318 097A              * On return from a device status call, only the first offline and disk switch
0319 097A              * status should be returned while the media remains offline.  Subsequent status
0320 097A              * calls with the media offline should return only the offline and omit the
0321 097A              * disk switched status.
0322 097A              *
0323 097A A7 04                 lda   [<drvr_slist_ptr]
0324 097C 29 01 00              and   #$0001
0325 097F F0 10                 beq   @05                      ;no
0326 0981              * only reset dsw for the internal SmartPort
0327 0981 2C 68 03              bit   ext_slot
0328 0984 30 0B                 bmi   @05
0329 0986              * only do the drive ejected latch reset for ROM 0001
0330 0986 AD 66 03              lda   |rom_version
0331 0989 C9 02 00              cmp   #$0002
0332 098C B0 03                 bge   @05
0333 098E              * for old rom only reset the drive latch
0334 098E 20 A9 09              jsr   reset_sts_dsw            ;clear drive dsw bit
0335 0991              *
0336 0991              * If a direct firmware access occured then fake a disk switched.
0337 0991              *
0338 0991 2E 56 03     @05      rol   |pre_check               ; did an access occur?
0339 0994 90 07                 bcc   @10                      ; no, continue with history check
0340 0996 A7 04                 lda   [<drvr_slist_ptr]
0341 0998 09 01 00              ora   #$0001                   ; yes, simulate a disk switched
0342 099B 87 04                 sta   [<drvr_slist_ptr]
0343 099D              *
0344 099D A0 50 00     @10      ldy   #dib_last_sts
0345 09A0 A7 04                 lda   [drvr_slist_ptr]         ;get status result word
0346 09A2 97 20                 sta   [drvr_dib_ptr],y         ;save this for online test
0347 09A4 A9 00 00              lda   #no_error
0348 09A7 18                    clc   
0349 09A8              not_dev_stat  
0350 09A8 60                    rts   
0351 09A9              **********************************************************************
0352 09A9              **********************************************************************
0353 09A9                       export reset_sts_dsw
0354 09A9 E2 30        reset_sts_dsw SEP   #$30
0355 09AB                       longa off
0356 09AB                       longi off
0357 09AB 20 25 17              jsr   enable_slot6
0358 09AE 20 A7 17              jsr   phases_off
0359 09B1 A0 0F                 ldy   #%00001111
0360 09B3 20 6D 17              jsr   IFf_set_mode
0361 09B6 AF E9 C0 E1           lda   >select                  ;reselect in case set_iwm_mode worked
0362 09BA 20 B8 15              jsr   enable_sense
0363 09BD 90 07                 bcc   @10                      ;drive ejected bit is not set
0364 09BF 10 05                 bpl   @10                      ;was just offline not dsw
0365 09C1 A9 03                 lda   #ejct_reset
0366 09C3 20 47 16              jsr   writebit                 ;clear the drive ejected latch
0367 09C6 A9 00        @10      lda   #00
0368 09C8 8F 31 C0 E1           sta   >diskreg                 ;deactivate /EN35 to cancel drive timer
0369 09CC EA                    nop   
0370 09CD EA                    nop   
0371 09CE EA                    nop   
0372 09CF 8F E8 C0 E1           sta   >deselect                ;now turn off the drive enable 
0373 09D3 20 A7 17              jsr   phases_off
0374 09D6 20 56 17              jsr   restore_slot6
0375 09D9                       longa on
0376 09D9                       longi on
0377 09D9 C2 30                 REP   #$30
0378 09DB 60                    rts   
0379 09DC
0380 09DC                       eject 
0381 09DC              *****************************************************************
0382 09DC              *
0383 09DC              * This routine returns the format options for the device.
0384 09DC              * Consult the driver specification for the format option list.
0385 09DC              * This call requires a minimum request count of $00000002.  The
0386 09DC              * maximum request count may exceed the size of the format list
0387 09DC              * in which case the request count returned will indicate the
0388 09DC              * size of the format list.
0389 09DC              *
0390 09DC              * ENTRY: via a 'JSR'
0391 09DC              *               A Reg = Call Number
0392 09DC              *               X Reg = Undefined
0393 09DC              *               Y Reg = Undefined
0394 09DC              *             Dir Reg = GS/OS Direct Page
0395 09DC              *               B Reg = Undefined
0396 09DC              *               P Reg = N V M X D I Z C  E
0397 09DC              *                       x x 0 0 0 0 x x  0
0398 09DC              *
0399 09DC              * EXIT: via an 'RTS'
0400 09DC              *               A Reg = Error code
0401 09DC              *               X Reg = Undefined
0402 09DC              *               Y Reg = Undefined
0403 09DC              *             Dir Reg = GS/OS Direct Page
0404 09DC              *               B Reg = Same as entry
0405 09DC              *               P Reg = N V M X D I Z C  E
0406 09DC              *                       x x 0 0 0 0 x 0  0   No error occured
0407 09DC              *                       x x 0 0 0 0 x 1  0   Error occured
0408 09DC              *
0409 09DC              *****************************************************************
0410 09DC                       export get_format
0411 09DC              get_format  
0412 09DC                       longa on
0413 09DC                       longi on
0414 09DC
0415 09DC A9 22 00              lda   #drvr_bad_parm           ; assume invalid request count
0416 09DF A6 0A                 ldx   <drvr_req_cnt+2          ; and validate request count
0417 09E1 D0 07                 bne   bad_get_format
0418 09E3 A6 08                 ldx   <drvr_req_cnt
0419 09E5 E0 02 00              cpx   #$0002
0420 09E8 B0 02                 bge   ok_get_format
0421 09EA              bad_get_format  
0422 09EA 38                    sec   
0423 09EB 60                    rts   
0424 09EC              *
0425 09EC              * Request count is valid. Return the format options for this device.
0426 09EC              *
0427 09EC 2C 68 03     ok_get_format bit   ext_slot            ; Internal device?
0428 09EF 10 50                 bpl   @doInternal
0429 09F1
0430 09F1              *** changed 25-Mar-93 DAL to return useful information in small buffers for FDHDs
0431 09F1              ***   The book says we can return $22 (g_dispatch is returning no error).
0432 09F1              ***   For compatibility, I'm electing to return partial information rather
0433 09F1              ***   than return an error (the book says we can do that, too).
0434 09F1              ;;;	jsl	g_dispatch
0435 09F1              ;;;	bcs	@doInternal	;use internal table if external fails
0436 09F1              ;;;	rts
0437 09F1
0438 09F1 D4 08                 pei   <drvr_req_cnt
0439 09F3 D4 06                 pei   <drvr_slist_ptr+2
0440 09F5 D4 04                 pei   <drvr_slist_ptr
0441 09F7
0442 09F7 A9 80 00              lda   #$0080
0443 09FA 85 08                 sta   <drvr_req_cnt
0444 09FC A9 02 00              lda   #^kludgeBuffer
0445 09FF 85 06                 sta   <drvr_slist_ptr+2
0446 0A01 A9 7D 0A              lda   #kludgeBuffer
0447 0A04 85 04                 sta   <drvr_slist_ptr
0448 0A06
0449 0A06 22 84 FC 01           jsl   g_dispatch
0450 0A0A
0451 0A0A 68                    pla   
0452 0A0B 85 04                 sta   <drvr_slist_ptr
0453 0A0D 68                    pla   
0454 0A0E 85 06                 sta   <drvr_slist_ptr+2
0455 0A10 68                    pla   
0456 0A11 85 08                 sta   <drvr_req_cnt
0457 0A13 B0 2C                 bcs   @doInternal
0458 0A15
0459 0A15              *** Figure out what the *real* transfer count is (8 + numFormats*16)
0460 0A15 AD 7D 0A              lda   kludgeBuffer
0461 0A18 0A                    asl   a
0462 0A19 0A                    asl   a
0463 0A1A 0A                    asl   a
0464 0A1B 0A                    asl   a
0465 0A1C 69 08 00              adc   #8
0466 0A1F C5 08                 cmp   <drvr_req_cnt            ; is request longer then list length?
0467 0A21 B0 02                 bge   @req_count_ok
0468 0A23 85 08                 sta   <drvr_req_cnt
0469 0A25              @req_count_ok  
0470 0A25
0471 0A25              *** Copy as much data as we can into the user's real buffer
0472 0A25
0473 0A25 F4 02 00              pea   kludgeBuffer>>16
0474 0A28 F4 7D 0A              pea   kludgeBuffer
0475 0A2B D4 06                 pei   <drvr_slist_ptr+2
0476 0A2D D4 04                 pei   <drvr_slist_ptr
0477 0A2F F4 00 00              pea   0
0478 0A32 D4 08                 pei   <drvr_req_cnt
0479 0A34 F4 05 08              pea   $0805                    ;move_sinc_dinc
0480 0A37 22 70 FC 01           jsl   move_info
0481 0A3B
0482 0A3B A5 08                 lda   <drvr_req_cnt            ;already doctored up as necessary
0483 0A3D 85 0C                 sta   <drvr_tran_cnt
0484 0A3F
0485 0A3F 18                    clc   
0486 0A40 60                    rts   
0487 0A41
0488 0A41              *** end 25-Mar-93
0489 0A41
0490 0A41 A0 4A 00     @doInternal ldy   #dib_hw_unit          ; internal device #
0491 0A44 B7 20                 lda   [<drvr_dib_ptr],y
0492 0A46 3A                    dec   a
0493 0A47 0A                    asl   a
0494 0A48 AA                    tax   
0495 0A49 BD 24 00              lda   |format_tbl,x            ; get pointer to format option list
0496 0A4C AA                    tax   
0497 0A4D BD 00 00              lda   |0,x                     ; get # entries in option list
0498 0A50 0A                    asl   a                        ; list length = (n * 16) + 8
0499 0A51 0A                    asl   a
0500 0A52 0A                    asl   a
0501 0A53 0A                    asl   a
0502 0A54 18                    clc   
0503 0A55 69 08 00              adc   #$0008                   ; now have option list length
0504 0A58 C5 08                 cmp   <drvr_req_cnt            ; is request longer then list length?
0505 0A5A B0 02                 bge   req_count_ok
0506 0A5C 85 08                 sta   <drvr_req_cnt
0507 0A5E              req_count_ok                            ; 
0508 0A5E A0 00 00              ldy   #$0000                   ; status list index
0509 0A61 E2 20                 sep   #$20                     ; 8 bit 'm'
0510 0A63                       longa off
0511 0A63              copy_format                             ;
0512 0A63 BD 00 00              lda   |0,x                     ; copy format option list to slist_ptr
0513 0A66 97 04                 sta   [<drvr_slist_ptr],y
0514 0A68 E8                    inx   
0515 0A69 C8                    iny   
0516 0A6A C4 08                 cpy   <drvr_req_cnt            ; copy = request count size
0517 0A6C D0 F5                 bne   copy_format
0518 0A6E C2 20                 rep   #$20                     ; 16 bit 'm'
0519 0A70                       longa on
0520 0A70
0521 0A70                       export set_xfer_cnt
0522 0A70              set_xfer_cnt                            ;
0523 0A70 A5 08                 lda   <drvr_req_cnt            ; set transfer count
0524 0A72 85 0C                 sta   <drvr_tran_cnt
0525 0A74 A5 0A                 lda   <drvr_req_cnt+2
0526 0A76 85 0E                 sta   <drvr_tran_cnt+2
0527 0A78 A9 00 00              lda   #no_error                ; and return with no error
0528 0A7B 18                    clc   
0529 0A7C 60                    rts   
0530 0A7D
0531 0A7D 00 00 00 00  kludgeBuffer DS B:$80                   ;added 25-Mar-93 DAL
0532 0AFD
0533 0AFD                       endp 
0534 0AFD                       eject 
0535 0AFD              *****************************************************************
0536 0AFD              *
0537 0AFD              * DRIVER CALL:  CONTROL
0538 0AFD              *
0539 0AFD              * This routine supports all the standard device control calls.
0540 0AFD              *
0541 0AFD              * Control Code: $0000   Reset Device
0542 0AFD              *               $0001   Format Device
0543 0AFD              *               $0002   eject Media
0544 0AFD              *               $0003   Set Control Parameters
0545 0AFD              *               $0004   Set Wait/No Wait Mode
0546 0AFD              *               $0005   Set Format Option
0547 0AFD              *               $0006   Assign Partition Owner
0548 0AFD              *               $0007   Arm Signal
0549 0AFD              *               $0008   Disarm Signal
0550 0AFD              *
0551 0AFD              * ENTRY: via a 'JSR'
0552 0AFD              *       <drvr_dev_num = Device Number of current device being accessed
0553 0AFD              *     <drvr_clist_ptr = Pointer to control list
0554 0AFD              *     <drvr_ctrl_code = Control code
0555 0AFD              *       <drvr_req_cnt = Number of bytes to be transferred
0556 0AFD              *      <drvr_tran_cnt = $00000000
0557 0AFD              *               A Reg = Call Number
0558 0AFD              *               X Reg = Undefined
0559 0AFD              *               Y Reg = Undefined
0560 0AFD              *             Dir Reg = GS/OS Direct Page
0561 0AFD              *               B Reg = Undefined
0562 0AFD              *               P Reg = N V M X D I Z C  E
0563 0AFD              *                       x x 0 0 0 0 x x  0
0564 0AFD              *
0565 0AFD              * EXIT: via an 'RTS'
0566 0AFD              *      <drvr_tran_cnt = Number of bytes transferred
0567 0AFD              *               A Reg = Error code
0568 0AFD              *               X Reg = Undefined
0569 0AFD              *               Y Reg = Undefined
0570 0AFD              *             Dir Reg = GS/OS Direct Page
0571 0AFD              *               B Reg = Same as entry
0572 0AFD              *               P Reg = N V M X D I Z C  E
0573 0AFD              *                       x x 0 0 0 0 x 0  0   No error occured
0574 0AFD              *                       x x 0 0 0 0 x 1  0   Error occured
0575 0AFD              *
0576 0AFD              *****************************************************************
0577 0AFD                       export control
0578 0AFD              control  proc 
0579 0AFD                                                      ;using   driver_data
0580 0AFD                       longa on
0581 0AFD                       longi on
0582 0AFD
0583 0AFD              *
0584 0AFD              * restore original read_data hooks before this call or system will
0585 0AFD              *    use patch incorrectly.
0586 0AFD              *
0587 0AFD AF 7B 0F E1           lda   >rd_hook+4               ;restore hook with original
0588 0B01 8F 77 0F E1           sta   >rd_hook+0
0589 0B05 AF 7D 0F E1           lda   >rd_hook+6
0590 0B09 8F 79 0F E1           sta   >rd_hook+2
0591 0B0D
0592 0B0D A5 16                 lda   <drvr_stat_code          ; is this a set format option call?
0593 0B0F C9 05 00              cmp   #drvr_set_format
0594 0B12 F0 11                 beq   set_format               ; yes, go set the interleave or sides
0595 0B14 C9 01 00              cmp   #drvr_format             ; is this a format call?
0596 0B17 F0 26                 beq   format                   ; yes, go do format and restore default
0597 0B19
0598 0B19 22 84 FC 01           jsl   g_dispatch               ; pass call on to generated core
0599 0B1D
0600 0B1D              control_return                          ;
0601 0B1D                       longa on
0602 0B1D                       longi on
0603 0B1D
0604 0B1D 08                    php                            ;save error status
0605 0B1E 48                    pha                            ;save error code
0606 0B1F
0607 0B1F 20 01 08              jsr   set_hook                 ;put back the patch and exit
0608 0B22
0609 0B22 68                    pla                            ;restore error code
0610 0B23 28                    plp                            ;restore error status
0611 0B24 60                    rts   
0612 0B25
0613 0B25                       eject 
0614 0B25              *****************************************************************
0615 0B25              *
0616 0B25              * This control call sets the format option in preperation for
0617 0B25              * a subsequent format control call.
0618 0B25              *
0619 0B25              * ENTRY: via a 'JSR'
0620 0B25              *       <drvr_dev_num = Device Number of current device being accessed
0621 0B25              *     <drvr_clist_ptr = Pointer to control list
0622 0B25              *     <drvr_ctrl_code = Control code
0623 0B25              *       <drvr_req_cnt = Number of bytes to be transferred
0624 0B25              *      <drvr_tran_cnt = $00000000
0625 0B25              *               A Reg = Call Number
0626 0B25              *               X Reg = Undefined
0627 0B25              *               Y Reg = Undefined
0628 0B25              *             Dir Reg = GS/OS Direct Page
0629 0B25              *               B Reg = Undefined
0630 0B25              *               P Reg = N V M X D I Z C  E
0631 0B25              *                       x x 0 0 0 0 x x  0
0632 0B25              *
0633 0B25              * EXIT: via an 'RTS'
0634 0B25              *      <drvr_tran_cnt = Number of bytes transferred
0635 0B25              *               A Reg = Error code
0636 0B25              *               X Reg = Undefined
0637 0B25              *               Y Reg = Undefined
0638 0B25              *             Dir Reg = GS/OS Direct Page
0639 0B25              *               B Reg = Same as entry
0640 0B25              *               P Reg = N V M X D I Z C  E
0641 0B25              *                       x x 0 0 0 0 x 0  0   No error occured
0642 0B25              *                       x x 0 0 0 0 x 1  0   Error occured
0643 0B25              *
0644 0B25              *****************************************************************
0645 0B25                       export set_format
0646 0B25              set_format                              ;
0647 0B25                       longa on
0648 0B25                       longi on
0649 0B25
0650 0B25 A7 04                 lda   [<drvr_slist_ptr]        ;get the format option
0651 0B27 D0 07                 bne   @10
0652 0B29 A9 22 00              lda   #drvr_bad_parm
0653 0B2C 38                    sec   
0654 0B2D 82 ED FF              brl   control_return           ;zero is not a valid option
0655 0B30 A0 4E 00     @10      ldy   #dib_fmt_optn
0656 0B33 97 20                 sta   [drvr_dib_ptr],y         ;save format option in case of fmt error
0657 0B35
0658 0B35 20 C9 0B              jsr   set_option               ;not called from here with a zero
0659 0B38
0660 0B38 A9 00 00              lda   #no_error
0661 0B3B 18                    clc   
0662 0B3C 82 DE FF              brl   control_return
0663 0B3F
0664 0B3F                       eject 
0665 0B3F              *****************************************************************
0666 0B3F              *
0667 0B3F              * This control call implements the format call and then restores
0668 0B3F              * the format option to the recomended default as specified in the
0669 0B3F              * format options list.
0670 0B3F              *
0671 0B3F              * ENTRY: via a 'JSR'
0672 0B3F              *       <drvr_dev_num = Device Number of current device being accessed
0673 0B3F              *     <drvr_clist_ptr = Pointer to control list
0674 0B3F              *     <drvr_ctrl_code = Control code
0675 0B3F              *       <drvr_req_cnt = Number of bytes to be transferred
0676 0B3F              *      <drvr_tran_cnt = $00000000
0677 0B3F              *               A Reg = Call Number
0678 0B3F              *               X Reg = Undefined
0679 0B3F              *               Y Reg = Undefined
0680 0B3F              *             Dir Reg = GS/OS Direct Page
0681 0B3F              *               B Reg = Undefined
0682 0B3F              *               P Reg = N V M X D I Z C  E
0683 0B3F              *                       x x 0 0 0 0 x x  0
0684 0B3F              *
0685 0B3F              * EXIT: via an 'RTS'
0686 0B3F              *      <drvr_tran_cnt = Number of bytes transferred
0687 0B3F              *               A Reg = Error code
0688 0B3F              *               X Reg = Undefined
0689 0B3F              *               Y Reg = Undefined
0690 0B3F              *             Dir Reg = GS/OS Direct Page
0691 0B3F              *               B Reg = Same as entry
0692 0B3F              *               P Reg = N V M X D I Z C  E
0693 0B3F              *                       x x 0 0 0 0 x 0  0   No error occured
0694 0B3F              *                       x x 0 0 0 0 x 1  0   Error occured
0695 0B3F              *
0696 0B3F              *****************************************************************
0697 0B3F                       export format
0698 0B3F              format                                  ;
0699 0B3F                       longa on
0700 0B3F                       longi on
0701 0B3F
0702 0B3F 20 67 05              jsr   check_access             ; did direct access occur?
0703 0B42 B0 23                 bcs   @exit                    ; yes
0704 0B44
0705 0B44 22 84 FC 01           jsl   g_dispatch               ; pass call on to generated core
0706 0B48 48                    pha   
0707 0B49 08                    php   
0708 0B4A A0 4E 00              ldy   #dib_fmt_optn
0709 0B4D 90 07                 bcc   @setDflts                ;if No error  set default option
0710 0B4F C9 2E 00              cmp   #drvr_disk_sw            ;did fmt return disk switched error?
0711 0B52 D0 02                 bne   @setDflts                ;no so reset to defaults
0712 0B54 B7 20                 lda   [drvr_dib_ptr],y         ;get last selected option
0713 0B56 A9 00 00     @setDflts lda   #0000                   ;tell set_option to restore "defaults"
0714 0B59 97 20        @fmtswitch sta   [drvr_dib_ptr],y       ;clear or save the format option 
0715 0B5B
0716 0B5B 20 C9 0B              jsr   set_option               ;reset the "default" options in a card 
0717 0B5E
0718 0B5E 28                    plp   
0719 0B5F B0 05                 bcs   @err                     ;format failed so can't fix the blkcount
0720 0B61 08                    php   
0721 0B62 20 6A 0B              jsr   Fixup_blkcnt             ;after format reset blkcnt in DIB to match
0722 0B65 28                    plp   
0723 0B66 68           @err     pla   
0724 0B67              @exit     
0725 0B67 82 B3 FF              brl   control_return
0726 0B6A              **********************************************************************
0727 0B6A              *
0728 0B6A              *  Update the DIB block count by making a DIB status call
0729 0B6A              **********************************************************************
0730 0B6A                       export Fixup_blkcnt
0731 0B6A              Fixup_blkcnt                            ;
0732 0B6A                       longa on
0733 0B6A                       longi on
0734 0B6A
0735 0B6A A0 30 00              ldy   #unit_num
0736 0B6D B7 20                 lda   [drvr_dib_ptr],y
0737 0B6F
0738 0B6F E2 20                 sep   #$20                     ; 8 bit 'm'
0739 0B71                       longa off
0740 0B71 8D E0 03              sta   dib_unit                 ;setup unit number for call
0741 0B74
0742 0B74 C2 20                 rep   #$20                     ; 16 bit 'm'
0743 0B76                       longa on
0744 0B76
0745 0B76 A5 00                 lda   <drvr_dev_num
0746 0B78 A2 DA 03              ldx   #dib_stat                ;extended DIB status call to firmware
0747 0B7B 22 80 FC 01           jsl   to_b0_core
0748 0B7F B0 47                 bcs   @error
0749 0B81
0750 0B81 AD E6 03              lda   dib_slist                ;get the status byte
0751 0B84 29 17 00              and   #%10111                  ;is media online?
0752 0B87 A0 50 00              ldy   #dib_last_sts
0753 0B8A 97 20                 sta   [drvr_dib_ptr],y         ;save last online status
0754 0B8C A2 00 00              ldx   #no_error
0755 0B8F 89 01 00              bit   #%00001                  ;is the result a disk switched status?
0756 0B92 F0 15                 beq   @10
0757 0B94 48                    pha   
0758 0B95              * only reset dsw for the internal SmartPort
0759 0B95 2C 68 03              bit   ext_slot
0760 0B98 30 0B                 bmi   @05
0761 0B9A              * only do the drive ejected latch reset for ROM 0001
0762 0B9A AD 66 03              lda   |rom_version
0763 0B9D C9 02 00              cmp   #$0002
0764 0BA0 B0 03                 bge   @05
0765 0BA2              * for old rom only reset the drive latch
0766 0BA2 20 A9 09              jsr   reset_sts_dsw            ;clear drive dsw bit
0767 0BA5 68           @05      pla   
0768 0BA6 A2 2E 01              ldx   #drvr_disk_sw+$100
0769 0BA9              @10       
0770 0BA9 89 10 00              bit   #$0010                   ;is media online?
0771 0BAC D0 05                 bne   @20                      ;yes.
0772 0BAE A9 2F 00              lda   #drvr_off_line
0773 0BB1 80 11                 bra   @exit                    ;nope
0774 0BB3 AD E7 03     @20      lda   dib_blkcnt               ;get blockcount from firmware
0775 0BB6 F0 0C                 beq   @exit                    ;blank media is online!
0776 0BB8 A0 0A 00              ldy   #blk_cnt
0777 0BBB 97 20                 sta   [drvr_dib_ptr],y
0778 0BBD AD E9 03              lda   dib_blkcnt+2
0779 0BC0 C8                    iny   
0780 0BC1 C8                    iny   
0781 0BC2 97 20                 sta   [drvr_dib_ptr],y         ;update the block count in the dib
0782 0BC4 8A           @exit    txa   
0783 0BC5 C9 01 00              cmp   #no_error+1
0784 0BC8 60           @error   rts   
0785 0BC9                       eject 
0786 0BC9              *****************************************************************
0787 0BC9              *
0788 0BC9              * This call actually sets the number of sides and interleave
0789 0BC9              *  or makes a SetFmtOption call to a Mustang card
0790 0BC9              *
0791 0BC9              * ENTRY: via a 'JSR'
0792 0BC9              *               A Reg = Option Number
0793 0BC9              *               X Reg = Undefined
0794 0BC9              *               Y Reg = Undefined
0795 0BC9              *             Dir Reg = GS/OS Direct Page
0796 0BC9              *               B Reg = Undefined
0797 0BC9              *               P Reg = N V M X D I Z C  E
0798 0BC9              *                       x x 0 0 0 0 x x  0
0799 0BC9              *
0800 0BC9              * EXIT: via an 'RTS'
0801 0BC9              *               A Reg = Error code
0802 0BC9              *               X Reg = Undefined
0803 0BC9              *               Y Reg = Undefined
0804 0BC9              *             Dir Reg = GS/OS Direct Page
0805 0BC9              *               B Reg = Same as entry
0806 0BC9              *               P Reg = N V M X D I Z C  E
0807 0BC9              *                       x x 0 0 0 0 x 0  0   No error occured
0808 0BC9              *                       x x 0 0 0 0 x 1  0   Error occured
0809 0BC9              *
0810 0BC9              *****************************************************************
0811 0BC9                       export set_option
0812 0BC9              set_option                              ;
0813 0BC9                       longa on
0814 0BC9                       longi on
0815 0BC9
0816 0BC9 48                    pha                            ; save format option
0817 0BCA
0818 0BCA A0 30 00              ldy   #unit_num                ; set unit number in parameter lists
0819 0BCD E2 20                 sep   #$20                     ; 8 bit 'm'
0820 0BCF                       longa off
0821 0BCF
0822 0BCF B7 20                 lda   [drvr_dib_ptr],y
0823 0BD1 8D 06 04              sta   sides_unit
0824 0BD4 8D 16 04              sta   ilv_unit
0825 0BD7 8D 35 04              sta   set_fmt_unit
0826 0BDA
0827 0BDA C2 20                 rep   #$20                     ; 16 bit 'm'
0828 0BDC                       longa on
0829 0BDC
0830 0BDC 68                    pla                            ; restore option number
0831 0BDD
0832 0BDD 2C 68 03              bit   ext_slot
0833 0BE0 10 22                 bpl   @Internal
0834 0BE2
0835 0BE2 8D 3C 04              sta   set_fmt_opt
0836 0BE5
0837 0BE5 A2 2F 04              ldx   #set_fmt_option
0838 0BE8 A5 00                 lda   <drvr_dev_num
0839 0BEA 22 80 FC 01           jsl   to_b0_core               ;4-Nov-92 DAL (was jsr, but assembler did jsl anyway)
0840 0BEE B0 13                 bcs   @05
0841 0BF0
0842 0BF0 AE 3C 04              ldx   set_fmt_opt              ;was this a "defaults" or specific option set?
0843 0BF3 D0 0E                 bne   @05                      ;specific option so all done
0844 0BF5              * Must now suppress the 800K 4:1 "default" option selection of Mustang card
0845 0BF5 A9 02 00              lda   #0002
0846 0BF8 8D 1E 04              sta   intlv                    ;force 2:1 interleave
0847 0BFB A9 80 00              lda   #$0080
0848 0BFE 8D 0E 04              sta   sides_cnt
0849 0C01 80 1D                 bra   @setDeflts               ;and double sided
0850 0C03 60           @05      rts   
0851 0C04
0852 0C04              @Internal  
0853 0C04 3A                    dec   a
0854 0C05 10 03                 bpl   @10                      ;zero means set the "default" = 0001
0855 0C07 A9 01 00              lda   #0001
0856 0C0A CD 28 00     @10      cmp   format1                  ;(number of entries)
0857 0C0D B0 28                 bge   option_error
0858 0C0F
0859 0C0F 0A                    asl   a
0860 0C10 0A                    asl   a
0861 0C11 AA                    tax   
0862 0C12 BD 50 00              lda   |option_xlate,x          ; get interleave
0863 0C15 8D 1E 04              sta   |intlv
0864 0C18 E8                    inx   
0865 0C19 E8                    inx   
0866 0C1A BD 50 00              lda   |option_xlate,x          ; get sides
0867 0C1D 8D 0E 04              sta   |sides_cnt
0868 0C20
0869 0C20 A5 00        @setDeflts lda   <drvr_dev_num
0870 0C22 A2 10 04              ldx   #set_intlv
0871 0C25 22 80 FC 01           jsl   to_b0_core
0872 0C29
0873 0C29 A5 00                 lda   <drvr_dev_num
0874 0C2B A2 00 04              ldx   #set_sides
0875 0C2E 22 80 FC 01           jsl   to_b0_core
0876 0C32
0877 0C32 A9 00 00              lda   #no_error
0878 0C35 18                    clc   
0879 0C36 60                    rts   
0880 0C37
0881 0C37              option_error                            ;
0882 0C37                       longa on
0883 0C37                       longi on
0884 0C37
0885 0C37 A9 22 00              lda   #drvr_bad_parm
0886 0C3A 38                    sec   
0887 0C3B 60                    rts   
0888 0C3C
0889 0C3C                       endp 
0890 0C3C                       eject 
0891 0C3C              *****************************************************************
0892 0C3C              *
0893 0C3C              * DRIVER CALL:  FLUSH
0894 0C3C              *
0895 0C3C              * This call writes any data in the devices internal buffer to
0896 0C3C              * the device.  It should be noted that this is a WAIT MODE call
0897 0C3C              * which is only supported by devices which maintain their own
0898 0C3C              * internal I/O buffer.  Devices that cannot write in NO WAIT mode
0899 0C3C              * do not support this call and will return with no error.
0900 0C3C              *
0901 0C3C              * ENTRY: via a 'JSR'
0902 0C3C              *       <drvr_dev_num = Device Number of current device being accessed
0903 0C3C              *      <drvr_tran_cnt = $00000000
0904 0C3C              *               A Reg = Call Number
0905 0C3C              *               X Reg = Undefined
0906 0C3C              *               Y Reg = Undefined
0907 0C3C              *             Dir Reg = GS/OS Direct Page
0908 0C3C              *               B Reg = Undefined
0909 0C3C              *               P Reg = N V M X D I Z C  E
0910 0C3C              *                       x x 0 0 0 0 x x  0
0911 0C3C              *
0912 0C3C              * EXIT: via an 'RTS'
0913 0C3C              *      <drvr_tran_cnt = Number of bytes transferred
0914 0C3C              *               A Reg = Error code
0915 0C3C              *               X Reg = Undefined
0916 0C3C              *               Y Reg = Undefined
0917 0C3C              *             Dir Reg = GS/OS Direct Page
0918 0C3C              *               B Reg = Same as entry
0919 0C3C              *               P Reg = N V M X D I Z C  E
0920 0C3C              *                       x x 0 0 0 0 x 0  0   No error occured
0921 0C3C              *                       x x 0 0 0 0 x 1  0   Error occured
0922 0C3C              *
0923 0C3C              *****************************************************************
0924 0C3C                       export flush
0925 0C3C              flush    proc 
0926 0C3C                                                      ;using   driver_data
0927 0C3C                       longa on
0928 0C3C                       longi on
0929 0C3C
0930 0C3C A9 00 00              lda   #no_error
0931 0C3F 18                    clc   
0932 0C40 60                    rts   
0933 0C41
0934 0C41                       endp 
0935 0C41                       eject 
0936 0C41              *****************************************************************
0937 0C41              *
0938 0C41              * DRIVER CALL:  SHUTDOWN
0939 0C41              *
0940 0C41              * This call prepares the driver for shutdown.  This may include
0941 0C41              * closing a character device as well as releasing any and all
0942 0C41              * system resources that may have been aquired by either a
0943 0C41              * STARTUP or OPEN call.
0944 0C41              *
0945 0C41              * ENTRY: via a 'JSR'
0946 0C41              *       <drvr_dev_num = Device Number of current device being accessed
0947 0C41              *      <drvr_tran_cnt = $00000000
0948 0C41              *               A Reg = Call Number
0949 0C41              *               X Reg = Undefined
0950 0C41              *               Y Reg = Undefined
0951 0C41              *             Dir Reg = GS/OS Direct Page
0952 0C41              *               B Reg = Undefined
0953 0C41              *               P Reg = N V M X D I Z C  E
0954 0C41              *                       x x 0 0 0 0 x x  0
0955 0C41              *
0956 0C41              * EXIT: via an 'RTS'
0957 0C41              *      <drvr_tran_cnt = Number of bytes transferred
0958 0C41              *               A Reg = Error code
0959 0C41              *               X Reg = Undefined
0960 0C41              *               Y Reg = Undefined
0961 0C41              *             Dir Reg = GS/OS Direct Page
0962 0C41              *               B Reg = Same as entry
0963 0C41              *               P Reg = N V M X D I Z C  E
0964 0C41              *                       x x 0 0 0 0 x 0  0   No error occured
0965 0C41              *                       x x 0 0 0 0 x 1  0   Error occured
0966 0C41              *
0967 0C41              *****************************************************************
0968 0C41                       export shutdn
0969 0C41              shutdn   proc 
0970 0C41                                                      ;using   driver_data
0971 0C41                       longa on
0972 0C41                       longi on
0973 0C41
0974 0C41 E2 20                 sep   #$20                     ; 8 bit 'm'
0975 0C43                       longa off
0976 0C43
0977 0C43 A0 30 00              ldy   #unit_num
0978 0C46 B7 20                 lda   [drvr_dib_ptr],y
0979 0C48 8D 26 04              sta   clr_intlv_unit
0980 0C4B 8D 35 04              sta   set_fmt_unit
0981 0C4E
0982 0C4E C2 20                 rep   #$20                     ; 16 bit 'm'
0983 0C50                       longa on
0984 0C50 9C 3C 04              stz   set_fmt_opt              ;reset options to defaults
0985 0C53
0986 0C53 A0 4A 00              ldy   #dib_hw_unit
0987 0C56 B7 20                 lda   [drvr_dib_ptr],y         ;is this 1st drive on a slot?
0988 0C58 C9 01 00              cmp   #0001
0989 0C5B D0 13                 bne   @10
0990 0C5D
0991 0C5D A0 2E 00              ldy   #slot_num
0992 0C60 B7 20                 lda   [drvr_dib_ptr],y
0993 0C62 89 08 00              bit   #%1000                   ;external slot shutdown?
0994 0C65 F0 09                 beq   @10                      ;only do 1 clr_fmt_option per External slot
0995 0C67
0996 0C67 A5 00                 lda   <drvr_dev_num            ; control call to set fmt option to defaults
0997 0C69 A2 2F 04              ldx   #set_fmt_option
0998 0C6C 22 80 FC 01           jsl   to_b0_core
0999 0C70
1000 0C70              @10       
1001 0C70 A0 2E 00              ldy   #slot_num                ;are we dealing with a Mustang here?
1002 0C73 B7 20                 lda   [<drvr_dib_ptr],y
1003 0C75 89 80 00              bit   #$80                     ;(must be an external slot)
1004 0C78 D0 2B                 bne   @20                      ;nope, it's the built-in SmartPort
1005 0C7A
1006 0C7A              ; Since Startup downloaded some code to Mustang to have Mustang store a flag into
1007 0C7A              ; the DIB when an external access occurs, we have to nullify the code to ensure
1008 0C7A              ; that Mustang doesn't try to write the flag byte into memory that no longer
1009 0C7A              ; belongs to us (for example, on a subsequent reboot). {GAB - 1/15/92}
1010 0C7A
1011 0C7A A0 30 00              ldy   #unit_num
1012 0C7D B7 20                 lda   [drvr_dib_ptr],y         ;get SmartPort Unit #
1013 0C7F
1014 0C7F E2 20                 sep   #$20                     ; 8 bit 'm'
1015 0C81                       longa off
1016 0C81 8D A8 04              sta   setAdrs_unit
1017 0C84 8D CD 04              sta   dnLoad_unit2
1018 0C87 C2 20                 rep   #$20                     ; 16 bit 'm'
1019 0C89                       longa on
1020 0C89
1021 0C89 0A                    asl   a
1022 0C8A AA                    tax   
1023 0C8B BD 8D 08              lda   dwnldAdrs-2,x
1024 0C8E 8D B0 04              sta   setAdrs_addr             ;fill in the adrs for this unit
1025 0C91
1026 0C91 A5 00                 lda   <drvr_dev_num            ;device number
1027 0C93 A2 A2 04              ldx   #setAdrs_list
1028 0C96 22 80 FC 01           jsl   to_b0_core
1029 0C9A B0 09                 bcs   @exit
1030 0C9C
1031 0C9C A5 00                 lda   <drvr_dev_num            ;device number
1032 0C9E A2 C7 04              ldx   #dnLoad_list2
1033 0CA1 22 80 FC 01           jsl   to_b0_core               ;download the 'rts' to the card's "ROM"
1034 0CA5              @exit     
1035 0CA5              @20       
1036 0CA5 CE 5A 03              dec   |device_count            ; number of appledisk3.5's online
1037 0CA8 D0 69                 bne   not_last
1038 0CAA
1039 0CAA AD 8E 00              lda   dib1_slot                ;1st dib always used but may be external
1040 0CAD 29 08 00              and   #%1000                   ;internal slot?
1041 0CB0 D0 38                 bne   @80
1042 0CB2
1043 0CB2              *
1044 0CB2              * Set default Internal firmware interleave to 4:1.
1045 0CB2              *
1046 0CB2 A5 00                 lda   <drvr_dev_num            ; control call to clr interleave (to 4:1)
1047 0CB4 A2 20 04              ldx   #clr_interleave
1048 0CB7 22 80 FC 01           jsl   to_b0_core
1049 0CBB              *
1050 0CBB              * Remove the merge patch for Internal SmartPort ONLY
1051 0CBB              *
1052 0CBB E2 20                 sep   #$20                     ; 8 bit 'm'
1053 0CBD                       longa off
1054 0CBD
1055 0CBD A0 30 00              ldy   #unit_num
1056 0CC0 B7 20                 lda   [<drvr_dib_ptr],y
1057 0CC2 8D 99 04              sta   |resethook_unit
1058 0CC5 A9 02                 lda   #$02                     ; hook refernece is for read data
1059 0CC7 8D A1 04              sta   |rsthook_ref
1060 0CCA
1061 0CCA C2 20                 rep   #$20                     ; 16 bit 'm'
1062 0CCC                       longa on
1063 0CCC
1064 0CCC A5 00                 lda   <drvr_dev_num            ; device number to read
1065 0CCE A2 93 04              ldx   #resethook_list
1066 0CD1 22 80 FC 01           jsl   to_b0_core
1067 0CD5              *
1068 0CD5              * Remove the access detection patch for Internal SmartPort ONLY
1069 0CD5 E2 20                 sep   #$20                     ; 8 bit 'm'
1070 0CD7                       longa off
1071 0CD7
1072 0CD7 A9 08                 lda   #$08                     ; hook refernece is for main entry
1073 0CD9 8D A1 04              sta   |rsthook_ref
1074 0CDC
1075 0CDC 9C E0 03              stz   dib_unit                 ;reset 8-bit unit # to zero
1076 0CDF
1077 0CDF C2 20                 rep   #$20                     ; 16 bit 'm'
1078 0CE1                       longa on
1079 0CE1
1080 0CE1 A5 00                 lda   <drvr_dev_num            ; device number to read
1081 0CE3 A2 93 04              ldx   #resethook_list
1082 0CE6 22 80 FC 01           jsl   to_b0_core
1083 0CEA              *
1084 0CEA              * Now clear the startup variables to make driver restartable from memory
1085 0CEA 9C 5A 03     @80      stz   device_count
1086 0CED 9C AC 00              stz   dib1acc_flag
1087 0CF0 9C 06 01              stz   dib2acc_flag
1088 0CF3 9C 60 01              stz   dib3acc_flag
1089 0CF6 9C BA 01              stz   dib4acc_flag
1090 0CF9 9C 14 02              stz   dib5acc_flag
1091 0CFC 9C 6E 02              stz   dib6acc_flag
1092 0CFF 9C C8 02              stz   dib7acc_flag
1093 0D02 9C 22 03              stz   dib8acc_flag
1094 0D05 9C 5E 03              stz   slot_count
1095 0D08 9C 60 03              stz   last_slot
1096 0D0B 9C 62 03              stz   last_drive
1097 0D0E
1098 0D0E A9 00 00              lda   #no_error                ; no error if all shutdown
1099 0D11 18                    clc   
1100 0D12 60                    rts   
1101 0D13
1102 0D13              not_last                                ;
1103 0D13 A9 29 00              lda   #drvr_busy               ; else return busy
1104 0D16 38                    sec   
1105 0D17 60                    rts   
1106 0D18
1107 0D18                       endp 
